# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2001 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CT::CU;
# "@(#)71   1.6   src/rsct/utils/ext/CT/CU/CU.pm, cucli, rsct_rori, roris01a 3/11/01 17:54:47"

use strict;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $AUTOLOAD);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
    CU_EFAILURE
    CU_EINVALIDNAME
    CU_ID_LEN
    CU_IP_ADDR_LEN
    CU_MAX_NAME_LEN
    CU_VERSION
);

@EXPORT_OK = qw(
    free_registry_server_list
    gen_resource_handle
    gen_resource_handle_ext
    get_canon_hndl
    get_cluster_ID
    get_cluster_info
    get_registry_server_list
    get_resource_location
    get_resource_id
    get_resource_id_ext
    get_resource_class_id
    rsrcs_are_same
    rsrc_hndl_cmp
);

$VERSION = '0.01';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
    if ($! =~ /Invalid/) {
        $AutoLoader::AUTOLOAD = $AUTOLOAD;
        goto &AutoLoader::AUTOLOAD;
    }
    else {
        croak "Your vendor has not defined CU macro $constname";
    }
    }
    *$AUTOLOAD = sub () { $val };
    goto &$AUTOLOAD;
}

bootstrap CT::CU $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__

=head1 NAME

CT::CU - Perl extensions for RSCT CU ct_cu.h 


=head1 SYNOPSIS

use CT::CU;
    

=head1 DESCRIPTION

This extension is used by the Reliable Scalable Cluster Technology
(RSCT) Cluster Utilities (CU) Commands.
CU Commands are located in /usr/sbin/rsct/bin.
Some of the CU Commands are: lsclcfg.

The Perl to C Extensions for RSCT Cluster Utilities (CU) layer,
CT::CU, are not being externalized at this time.
Use at your own risk!
The API to these extensions will probably change.


=head1 EXPORTED CONSTANTS

For more information regarding these exported constants see the file:
    /usr/include/rsct/ct_cu.h

    CU_EFAILURE
    CU_EINVALIDNAME
    CU_ID_LEN
    CU_IP_ADDR_LEN
    CU_MAX_NAME_LEN
    CU_VERSION


=head1 Exported Functions

For more information regarding these exported functions see the file:
    /usr/include/rsct/ct_cu.h

    free_registry_server_list
    gen_resource_handle
    gen_resource_handle_ext
    get_canon_hndl
    get_cluster_ID
    get_cluster_info
    get_registry_server_list
    get_resource_location
    get_resource_id
    get_resource_id_ext
    get_resource_class_id
    rsrcs_are_same
    rsrc_hndl_cmp

=over 4

=item get_cluster_ID($cluster_name, $cluster_ID) 

Given a cluster name this function returns the
corresponding cluster ID.

extern ct_int32_t
cu_get_cluster_ID(
    char * cluster_name,
    char * clusterID
);

$cluster_name   string   (input) name of one of
                         the clusters where this
                         node is defined.

$cluster_ID     string   (output) unique id 
                         that represents this 
                         cluster.

=item get_cluster_info(cluster_info_t)

Returns the current cluster information for the node 
where the command is run.  A node can be defined in 
more than one cluster but it can only be online or
online pending in one cluster. That is the current 
cluster.

extern ct_int32_t
cu_get_cluster_info(
    cluster_info_t *cluster_info      
);

cluster_info_t  class    (in/out)
    Use the following functions to access the members
    of this class:
        get_cluster_name()
        get_cluster_ID()
        get_node_number()
=back


=head1 EXAMPLES

Experiment with these code snippets to get a quick feel for
the behavior of this module.           
WARNING - Use at your own risk.  

    use CT::CU;

    $cluster_info = CT::CU::cluster_info_t->new; 
    $rc = get_cluster_info($cluster_info);
    if ($rc == 0) {
        print "cluster_name = ", get_cluster_name($cluster_info), "\n";
        print "cluster_id   = ", get_cluster_ID($cluster_info), "\n";
        print "node_number  = ", get_node_number($cluster_info), "\n";
    }


    use CT::CU;

    $cluster_name = "cluster1";
    $rc = get_cluster_ID($cluster_name, $cluster_id);
    if ($rc == 0) {
        print "cluster_name = ", $cluster_name, "\n"; 
        print "cluster_id   = ", $cluster_id);
    }


=head1 AUTHOR

Licensed Materials - Property of IBM 
  
(C) COPYRIGHT International Business Machines Corp. 1998, 2001.
All Rights Reserved.
  
US Government Users Restricted Rights - Use, duplication or 
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.


=head1 VERSION

RSCT Version 2.2


=head1 SEE ALSO

CT::CT

=cut
